<?php

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once __DIR__ . '/v4Updater.php';

include __DIR__ . '/templates/header.php';

global $mod_strings;

$packages = v4Updater::get_extensions();

?>
    <div class="card-outer panel-outer listview-panel panel-system panel-border" style="margin-top: 2rem">
        <div class="card-header panel-header listview-header listview-title-header">
            <h3 class="no-margin"><?= $mod_strings['LBL_INSTALLED_PACKAGES'] ?></h3>
        </div>

        <div class="card-body panel-body listview-body">
            <table class="listView" width="100%">
                <thead class="listViewColumns">
                <tr class="listHead">
                    <th class="listViewThS1">
                        <div class="listColLabel">&nbsp;</div>
                    </th>
                    <th class="listViewThS1">
                        <div class="listColLabel"><?= $mod_strings['LBL_NAME'] ?></div>
                    </th>
                    <th class="listViewThS1">
                        <div class="listColLabel"><?= $mod_strings['LBL_INSTALLED'] ?></div>
                    </th>
                    <th class="listViewThS1">
                        <div class="listColLabel"><?= $mod_strings['LBL_AVAILABLE'] ?></div>
                    </th>
                    <th class="listViewThS1">
                        <div class="listColLabel"><?= $mod_strings['LBL_CHANGELOG'] ?></div>
                    </th>
                    <th class="listViewThS1">
                        <div class="listColLabel"><?= $mod_strings['LBL_DOWNLOAD'] ?></div>
                    </th>
                </tr>
                </thead>
                <tbody>
                <?php
                $updater_list_i = 0;
                foreach ($packages as $package_id => $package) {
                    $updater_list_i++;
                    $current_package = current($package);
                    $info = v4Updater::check_for_updates($package_id);
                    $info = json_decode($info, true);
                    $status = $info['status'];

                    $update_status = 'n.a.';
                    if ($status === 'ok') {
                        if (version_compare($current_package->version, $info['version'], '<')) {
                            $update_status = 'update';
                        } else {
                            $update_status = 'up-to-date';
                        }
                    }
                    $row_style = $updater_list_i % 2 == 1 ? 'oddListRowS1' : 'evenListRowS1';
                    ?>
                    <tr class="listViewRow <?= $row_style ?>">
                        <td class="listViewTd">
                            <span class="uii uii-led <?php echo $status === 'ok' ? $update_status === 'update' ? 'led-red' : 'led-green' : 'led-grey'; ?>"></span>
                        </td>
                        <td class="listViewTd">
                            <h5 class="no-margin"><?= $current_package->name ?></h5>
                        <td class="listViewTd">
                            <?= $current_package->version ?>
                        </td>
                        <td class="listViewTd">
                            <?php if ($status === 'ok') echo $info['version']; else echo '-'; ?>
                        </td>
                        <td class="listViewTd">
                            <div class="buttons-inline">
                                <div class="inline-elt">
                                    <?php
                                    if (!empty($info['sections']['changelog'])) {
                                        echo '<a onclick="showChangeLog(\''.$package_id.'\'); return false;" href="index.php?module=v4Updater&action=view_changelog&package=' . $package_id . '">' . $mod_strings['LBL_CHANGELOG'] . '</a>';
                                    } else {
                                        echo '-';
                                    }
                                    ?>
                                </div>
                            </div>
                        </td>
                        <td class="listViewTd">
                            <div class="buttons-inline">
                                <div class="inline-elt">
                                    <?php
                                    if ($update_status === 'update') {
                                        echo '<a href="index.php?module=v4Updater&action=download_package&package=' . $package_id . '">' . $mod_strings['LBL_DOWNLOAD'] . '</a>';
                                    } elseif ($update_status === 'up-to-date') {
                                        echo $mod_strings['LBL_UPTODATE'];
                                    } else {
                                        echo '-';
                                    }
                                    ?>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr class="listViewRow <?= $row_style ?>">
                        <td class="listViewTd">&nbsp;</td>
                        <td class="listViewTd" colspan="5">
                            <div class="listAddLine"><?= $info['desc'] ?? $current_package->description ?></div>
                        </td>
                    </tr>
                    <?php
                }
                ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-outer panel-outer listview-panel panel-system panel-border" style="margin-top: 2rem">
        <div class="card-body panel-body listview-body">
            <table class="listView" width="100%">
                <tbody>
                <tr class="listViewRow oddListRowS1">
                    <td class="listViewTd">
                        <p class="no-margin"><?= $mod_strings['LBL_SUPPORT_DESCRIPTION'] ?></p>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </div>
<?php

include __DIR__ . '/templates/footer.php';
