<?php
 if(!defined('sugarEntry'))define('sugarEntry', true);
/*********************************************************************************
 * The contents of this file are subject to the SugarCRM Public License Version
 * 1.1.3 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.sugarcrm.com/SPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by SugarCRM" logo and
 *    (ii) the SugarCRM copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: SugarCRM Open Source
 * The Initial Developer of the Original Code is SugarCRM, Inc.
 * Portions created by SugarCRM are Copyright (C) 2004-2006 SugarCRM, Inc.;
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
 ********************************************************************************/

define('IAH_IN_INSTALLER', true);
define('ONECRM_CSRF_PROTECT', 'none');
$B2C = false;

require_once 'install/CmdLine.php';

define('CLI_INSTALLER', PHP_SAPI == 'cli');
define('AUTO_INSTALLER', CLI_INSTALLER || isset($_REQUEST['auto']));

try {
// switch to owner of the current file to preserve file permissions
if(CLI_INSTALLER && function_exists('posix_getpwuid')) {
	$puser = posix_getpwuid(posix_geteuid());
	if($puser && $puser['name'] == 'root') {
		$uid = getmyuid();
		$gid = getmygid();
		if($uid !== false && $uid != $puser['uid']) {
			posix_setegid($gid);
			posix_seteuid($uid);
		}
	}
}

require_once('include/config/AppConfig.php');

$systemCheckErrors = array();

if(AppConfig::setting('site.performance.suppress_display_errors')) {
	ini_set('display_errors', 0);
}

if(AppConfig::setting('site.performance.suppress_deprecation_warnings')) {
	error_reporting(error_reporting() & ~ constant('E_DEPRECATED'));
}
if(AppConfig::setting('site.performance.suppress_strict_warnings')) {
	// hide strictnesss warnings in PHP 5.4+
	error_reporting(error_reporting() & ~ constant('E_STRICT'));
}

require_once('vendor/autoload.php');
require_once('sugar_version.php');
require_once('include/utils/CacheManager.php');
require_once('include/utils.php');
require_once('include/paths.php');
require_once('install/install_utils.php');
require_once('install/ConfigParser.php');

setPhpIniSettings();
AppConfig::session_start();
$log = AppConfig::create_logger('INSTALL');


if(array_get_default($_REQUEST, 'goto') == 'Finish') {
	installer_cleanup();
	header('Location: login.php');
	return;
}

if(empty($_GET['async']) && ! check_install_permissions($fail_reason)) {
	installer_load_language();
	include('install/installDisabled.php');
	return;
}

$magic_q = function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc();
if ($magic_q) {
	$_REQUEST = array_map("stripslashes_checkstrings", $_REQUEST);
	$_POST = array_map("stripslashes_checkstrings", $_POST);
	$_GET = array_map("stripslashes_checkstrings", $_GET);
}
clean_special_arguments();
installer_load_language(array_get_default($_REQUEST, 'language'), true, true);


require_once('include/TimeDate.php');
require_once('include/Localization/Localization.php');
require_once('modules/ACL/ACLController.php');
$timedate = new TimeDate();
$locale = new Localization();
$setup_sugar_version = $sugar_version;
$install_script = true;
if(isset($_SESSION['setup_server_timezone']))
	AppConfig::set_system_timezone($_SESSION['setup_server_timezone']);
else
	AppConfig::set_system_timezone(AppConfig::system_timezone());

if (CLI_INSTALLER) {
	$options = InstallerCmdLine::parseOptions();
	foreach ($options as $k => $v) {
		$_SESSION[$k] = $v;
	}
	if (isset($options['installer_config_file'])) {
		$err = InstallerConfigParser::processConfigZip($options['installer_config_file']);
		if ($err)
			InstallerCmdLine::reportStatus(array_get_default($mod_strings, $err, $err), 'error');
		else {
			$defaults = InstallerConfigParser::parseConfigFile();
			foreach ($defaults as $k => $v) {
				$_SESSION[$k] = $v;
			}
		}
	}
}

if (! empty($_GET['async']) && empty($_SESSION['async_install_enabled'])) {
	die('no access');
}

if (! empty($_GET['async']) && $_GET['async'] === 'progress') {
	include('install/asyncProgress.php');
	exit;
}



if(array_get_default($_REQUEST, 'page') == 'licensePrint') {
	include('install/licensePrint.php');
	return;
}

require_once('include/database/ListQuery.php');


$next_clicked = false;
$next_step = 0;

// use a simple array to map out the steps of the installer page flow
$workflow = array(
	'welcome.php',
	'license.php',
	'checkSystem.php',
	'dbConfig.php',
	'siteConfig.php',
	'localization.php',
	'confirmSettings.php',
	'performSetup.php',
);

if(! empty($_SESSION['setup_db_pop_demo_data']) ){
	$workflow[] = 'demoConfig.php';
	$workflow[] = 'demoSetup.php';
}

if (AUTO_INSTALLER) {
	$workflow = array(
		'auto.php',
	);
	if (!CLI_INSTALLER) {
		$web_root = $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
		$web_root = preg_replace('~/install\.php.*$~', '', $web_root); // cn: bug 6898 add port if not 80
		$web_root = str_replace(":80/", "/", $web_root); // cn: bug 6898 keep old behavior
		$web_root = "http://$web_root";

		$_SESSION['setup_site_url'] = $web_root;
		$_SESSION['setup_site_admin_password'] = 'admin';
		$_SESSION['setup_site_admin_password_retype']   = 'admin';
	}

}


// increment/decrement the workflow pointer
if(!empty($_REQUEST['goto'])){
    switch($_REQUEST['goto']){
        case 'Re-check':
            $next_step = $_REQUEST['current_step'];
            break;
        case 'Back':
            $next_step = $_REQUEST['current_step'] - 1;
            break;
        case 'Next':
        case 'Start':
            $next_step = $_REQUEST['current_step'] + 1;
            $next_clicked = true;
            break;
        case 'SilentInstall':
            $next_clicked = true;
            $next_step = 9999;
            break;
    }
}

if ($next_step < 0)
	$next_step = 0;


$validation_errors = array();

if (CLI_INSTALLER)  {
	include 'install/checkSystem.php';
}

// process the data posted
if($next_clicked){
	if (AUTO_INSTALLER)  {
		include 'install/checkSystem.php';
	}
	// store the submitted data because the 'Next' button was clicked
    switch($workflow[trim($_REQUEST['current_step'])]){
        case 'welcome.php':
            if(! isset($_SESSION['setup_db_type']))
                $_SESSION['setup_db_type'] = AppConfig::setting('install.defaults.database.type');
            break;
        case 'license.php':
            $_SESSION['setup_license_accept'] = get_boolean_from_request('setup_license_accept');
            $_SESSION['license_submitted'] = true;
            break;
        case 'auto.php':
        case 'dbConfig.php':
            $_SESSION['setup_db_host_name']                     = $_REQUEST['setup_db_host_name'];
            if(isset($_REQUEST['setup_db_host_instance'])){
				$_SESSION['setup_db_host_instance']             = $_REQUEST['setup_db_host_instance'];
            }else{
            	$_SESSION['setup_db_host_instance']             = "";
            }
            $_SESSION['setup_db_database_name']                 = $_REQUEST['setup_db_database_name'];
            $_SESSION['setup_db_create_database']               = get_boolean_from_request( 'setup_db_create_database' );
            $_SESSION['setup_db_sugarsales_user']               = $_REQUEST['setup_db_sugarsales_user'];
            $_SESSION['setup_db_create_sugarsales_user']        = get_boolean_from_request( 'setup_db_create_sugarsales_user' );
            $_SESSION['setup_db_sugarsales_password']           = $_REQUEST['setup_db_sugarsales_password'];
            $_SESSION['setup_db_sugarsales_password_retype']    = $_REQUEST['setup_db_sugarsales_password_retype'];
            $_SESSION['setup_db_drop_tables']                   = get_boolean_from_request( 'setup_db_drop_tables' );
            $_SESSION['setup_db_pop_demo_data']                 = get_boolean_from_request( 'setup_db_pop_demo_data' );
            $_SESSION['setup_db_use_mb_demo_data']					= get_boolean_from_request('setup_db_use_mb_demo_data');
            $_SESSION['setup_db_username_is_privileged']        = get_boolean_from_request( 'setup_db_username_is_privileged' );
            if( ($_SESSION['setup_db_username_is_privileged'] == true)) {
                $_SESSION['setup_db_admin_user_name']           = $_SESSION['setup_db_sugarsales_user'];
                $_SESSION['setup_db_admin_password']            = $_SESSION['setup_db_sugarsales_password'];
            }
            else{
                $_SESSION['setup_db_admin_user_name']           = $_REQUEST['setup_db_admin_user_name'];
                $_SESSION['setup_db_admin_password']            = $_REQUEST['setup_db_admin_password'];
            }
            $_SESSION['dbConfig_submitted']                     = true;
            $validation_errors = validate_dbConfig();
            if(count($validation_errors)){
				if (!AUTO_INSTALLER) $next_step--;
            }
            break;
        case 'siteConfig.php':
            $_SESSION['setup_site_url']                     = $_REQUEST['setup_site_url'];
            $_SESSION['setup_site_admin_password']          = $_REQUEST['setup_site_admin_password'];
            $_SESSION['setup_site_admin_password_retype']   = $_REQUEST['setup_site_admin_password_retype'];
            $_SESSION['setup_site_defaults']                = get_boolean_from_request( 'setup_site_defaults' );
            $_SESSION['setup_site_custom_session_path']     = get_boolean_from_request( 'setup_site_custom_session_path' );
            $_SESSION['setup_site_session_path']            = $_REQUEST['setup_site_session_path'];
            $_SESSION['setup_site_custom_log']          = get_boolean_from_request( 'setup_site_custom_log' );
            $_SESSION['setup_site_log_dir']                 = $_REQUEST['setup_site_log_dir'];
            $_SESSION['setup_site_log_file']                = $_REQUEST['setup_site_log_file'];
            $_SESSION['setup_site_specify_guid']            = get_boolean_from_request( 'setup_site_specify_guid' );
            $_SESSION['setup_site_guid']                    = $_REQUEST['setup_site_guid'];
			$_SESSION['setup_server_timezone']          	= $_REQUEST['setup_server_timezone'];
			$_SESSION['setup_save_config']					= get_boolean_from_request('setup_save_config');
            $_SESSION['setup_system_name']                  = array_get_default($_REQUEST, 'setup_system_name', '');
            $_SESSION['siteConfig_submitted']               = true;
            $validation_errors = validate_siteConfig();
            if(count($validation_errors) > 0) {
                $next_step--;
            }
            break;
        case 'localization.php':
        	$_SESSION['default_date_format'] = $_REQUEST['default_date_format'];
        	$_SESSION['default_time_format'] = $_REQUEST['default_time_format'];
        	$_SESSION['default_language'] = $_REQUEST['default_language'];
        	$_SESSION['default_locale_name_format'] = $_REQUEST['default_locale_name_format'];
        	$_SESSION['default_email_charset'] = $_REQUEST['default_email_charset'];
        	$_SESSION['default_export_charset'] = $_REQUEST['default_export_charset'];
        	$_SESSION['default_export_format'] = $_REQUEST['default_export_format'];
        	$_SESSION['default_currency_name'] = $_REQUEST['default_currency_name'];
        	$_SESSION['default_currency_symbol'] = $_REQUEST['default_currency_symbol'];
        	$_SESSION['default_currency_iso4217'] = $_REQUEST['default_currency_iso4217'];
        	$_SESSION['default_currency_significant_digits'] = $_REQUEST['default_currency_significant_digits'];
        	$_SESSION['default_number_format'] = $_REQUEST['default_number_format'];
        	$_SESSION['default_address_format'] = $_REQUEST['default_address_format'];
			$validation_errors = validate_localization();
			if(count($validation_errors) > 0) {
				$next_step--;
			}
	        break;
	}
}

if (CLI_INSTALLER)
	$next_step = 9999;

if($next_step == 9999) {
    $the_file = 'SilentInstall';
} else {
    $the_file = $workflow[$next_step];
}

if ($next_step < 0)
	$next_step = 0;

switch($the_file) {
    case 'welcome.php':
        break;
    case 'SilentInstall':
		//pullSilentInstallVarsIntoSession();
		$validation_errors = validate_dbConfig();
		if (!CLI_INSTALLER) {
			$configParseErr = InstallerConfigParser::upload('installer_config');
			if ($configParseErr) {
				$validation_errors[] = array_get_default($mod_strings, $configParseErr, $configParseErr);
			}
			$defaults = InstallerConfigParser::parseConfigFile('');
			foreach ($defaults as $k => $v) {
				$_SESSION[$k] = $v;
			}
		}
		if( count($validation_errors) || (is_countable($systemCheckErrors) && count($systemCheckErrors)) ){
			if (CLI_INSTALLER) {
				InstallerCmdLine::reportStatus($validation_errors + $systemCheckErrors, 'error');
			}
            $the_file = AUTO_INSTALLER ? 'auto.php' : 'dbConfig.php';
        } else {
            $validation_errors = validate_siteConfig();
            if( count($validation_errors) > 0 ){
				if (CLI_INSTALLER) {
					InstallerCmdLine::reportStatus($validation_errors, 'error');
				}
                $the_file = 'siteConfig.php';
            }
			else {
				if (CLI_INSTALLER) {
					InstallerCmdLine::message("\n\n" . $mod_strings['LBL_SETUP_CLI'] . "\n");
					$the_file = 'asyncSetup.php';
				} else {
					$the_file = 'performSetup.php';
				}
            }
        }
        //since this is a SilentInstall we still need to make sure that
        //the appropriate files are writable
        // local_config.php
        make_writable(AppConfig::local_config_path());

        // custom dir
        make_writable('./custom');

        // modules dir
        recursive_make_writable('./modules');

        // cache dir
        // FIXME - use paths in system config
        /*make_writable('./cache/custom_fields');
        make_writable('./cache/dyn_lay');
        make_writable('./cache/images');
        make_writable('./cache/import');
        make_writable('./cache/layout');
        make_writable('./cache/pdf');
        make_writable('./cache/upload');
        make_writable('./cache/xml');*/

        // check whether we're getting this request from a command line tool
        // we want to output brief messages if we're outputting to a command line tool
        $cli_mode = false;
        if( isset($_REQUEST['cli']) && ($_REQUEST['cli'] == 'true')) {
            $_SESSION['cli'] = true;
            // if we have errors, just shoot them back now
            if( count($validation_errors) > 0 ){
                foreach( $validation_errors as $error ){
                    print( $mod_strings['ERR_ERROR_GENERAL']."\n" );
                    print( "    " . $error . "\n" );
                    print( "Exit 1\n" );
                    exit( 1 );
                }
            }
        }
        break;
}

if (array_get_default($_GET, 'async') == 'perform') {
	include 'install/asyncSetup.php';
	sugar_cleanup(true);
}

if (array_get_default($_GET, 'async') == 'demo') {
	include 'install/asyncDemo.php';
	sugar_cleanup(true);
}


$the_file = clean_string($the_file, 'FILE');

// change to require to get a good file load error message if the file is not available.
require('install/' . $the_file);
if (CLI_INSTALLER && $the_file == 'asyncSetup.php' && !empty($_SESSION['setup_db_pop_demo_data'])) {
	InstallerCmdLine::message("\n\n" . $mod_strings['LBL_DEMOSETUP_CLI'] . "\n");
	require('install/asyncDemo.php');
}

if (CLI_INSTALLER) {
	// exits:
	InstallerCmdLine::reportStatus($mod_strings['LBL_COMPLETE_CLI'], 'success');
} else {
	if(AppConfig::setting('install.debug.show_stage')) {
		if(isset($workflow[$next_step+1]))
			$next = '<br>Next: '.$workflow[$next_step+1];
		else
			$next = '';
		echo "<div style='background: white; border: grey; padding: 4px; position: fixed; top: 10px; left: 10px'>{$the_file}{$next}</div>";
	}
}


@ob_flush();

sugar_cleanup(true);
} catch (Exception $e) {
	if (CLI_INSTALLER) {
		InstallerCmdLine::reportStatus($e->getMessage(), 'crash');
	} else {
		throw $e;
	}
}
