<?php

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

class v4Updater
{
    private static $package_type = '1crm-extensions';
    private static $domain = 'https://updates.visual4.de';
    private static $licencetest = 'T35T-K3Y1';

    public static function get_extensions()
    {
        $uhis = ListQuery::quick_fetch_all_objects('UpgradeHistory');
        $packages = [];
        foreach ($uhis as $item) {
            $packages[$item->id_name][] = $item;
        }

        foreach ($packages as $package_id => $package) {
            usort($packages[$package_id], function ($a, $b) {
                return -1 * version_compare($a->version, $b->version);
            });
        }

        if (!key_exists('v4updater', $packages)) {
            require_once 'modules/Administration/UpgradeHistory.php';
            $v4updater = new UpgradeHistory();
            $v4updater->name = 'Updater';
            $v4updater->id_name = 'v4updater';
            $v4updater->version = AppConfig::version();
            $v4updater->description = 'Updater für 1CRM Erweiterungen';
            $packages['v4updater'][] = $v4updater;
        }

        return $packages;
    }

    public static function check_for_updates($package_id)
    {
        $url = self::$domain . '/v4-updater.php';
        $url .= '?' . http_build_query([
                'type' => self::$package_type,
                'slug' => $package_id,
                'license_key' => urlencode(self::$licencetest)
            ]);

        // create curl resource
        $ch = curl_init();

        // set url
        curl_setopt($ch, CURLOPT_URL, $url);

        //return the transfer as a string
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        // follow redirects
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

        if (
            ($_SERVER['SERVER_ADDR'] == '127.0.0.1' && $_SERVER['REMOTE_ADDR'] == '127.0.0.1') //allow local tests
        ) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        }

        // $output contains the output string
        $output = curl_exec($ch);

        // curl errors
        $error = curl_error($ch);
        if (!empty($error))
            error_log('v4Updater Error: ' . $error);

        // close curl resource to free up system resources
        curl_close($ch);

        return $output;
    }

    public static function download_package($package_id)
    {
        $result = self::check_for_updates($package_id);
        $result = json_decode($result, true);
        if ($result['status'] !== 'ok')
            return false;

        //The resource that we want to download.
        $fileUrl = $result['download_link'];

        //The path & filename to save to.
        $saveTo = AppConfig::cache_dir() . 'upgrades/module/' . $result['slug'] . '_' . $result['version'] . '.zip';

        //Create path if not exists
        $dir = dirname($saveTo);
        if (!is_dir($dir)) {
            if (!mkdir($dir, 0777, true) && !is_dir($dir)) {
                throw new Exception('Verzeichnis konnte nicht erstellt werden: ' . $dir);
            }
        }

        //Open file handler.
        $fp = fopen($saveTo, 'w+');

        //If $fp is FALSE, something went wrong.
        if ($fp === false) {
            throw new Exception('Could not open: ' . $saveTo);
        }

        //Create a cURL handle.
        $ch = curl_init($fileUrl);

        //Pass our file handle to cURL.
        curl_setopt($ch, CURLOPT_FILE, $fp);

        //Timeout if the file doesn't download after 20 seconds.
        curl_setopt($ch, CURLOPT_TIMEOUT, 20);

        //Execute the request.
        curl_exec($ch);

        //If there was an error, throw an Exception
        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch));
        }

        //Get the HTTP status code.
        $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        //Close the cURL handler.
        curl_close($ch);

        //Close the file handler.
        fclose($fp);

        if ($statusCode == 200) {
            return 'Success!';
        } else {
            throw new Exception("Status Code: " . $statusCode, $statusCode);
        }
    }

    public static function view_changelog($package_id)
    {
        global $mod_strings;

        $result = self::check_for_updates($package_id);
        $result = json_decode($result, true);
        if ($result['status'] !== 'ok')
            return false;

        $changelog_url = self::$domain . '/v4-updater.php';
        $changelog_url .= '?' . http_build_query([
                'action' => 'changelog',
                'type' => self::$package_type,
                'slug' => $package_id,
                'license_key' => urlencode(self::$licencetest)
            ]);

        $packages = self::get_extensions();
        $current_package = $packages[$package_id][0];

        $output = "<p><strong>{$result['name']}</strong>";
        if (version_compare($current_package->version, $result['version'], '<')) {
            $output .= ' - <a href="index.php?module=v4Updater&action=download_package&package=' . $package_id . '">' . $mod_strings['LBL_DOWNLOAD'] . '</a>';
        }
        $output .= '</p>';


        if (!empty($result['sections']['changelog'])) {
            $statusCode = 200;
            $output .= $result['sections']['changelog'];
        } else {
            // create curl resource
            $ch = curl_init();
            // set url
            curl_setopt($ch, CURLOPT_URL, $changelog_url);
            //return the transfer as a string
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            // follow redirects
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            //Timeout if the file doesn't download after 20 seconds.
            curl_setopt($ch, CURLOPT_TIMEOUT, 20);
            //Execute the request.
            $output .= curl_exec($ch);
            //If there was an error, throw an Exception
            if (curl_errno($ch)) {
                throw new Exception(curl_error($ch));
            }
            //Get the HTTP status code.
            $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            //Close the cURL handler.
            curl_close($ch);
        }

        if ($statusCode == 200) {
            //return curl body
            return $output;
        } else {
            throw new Exception("Status Code: " . $statusCode, $statusCode);
        }
    }
}
